//==============================================================================
//
//  Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
//  All Rights Reserved.
//  Confidential and Proprietary - Qualcomm Technologies, Inc.
//
//==============================================================================

#pragma once

#include <atomic>
#include <memory>

#include "GenieEmbedding.h"
#include "Util/HandleManager.hpp"
#include "qualla/embedding.hpp"

namespace genie {

class Embedding {
 public:
  class Config {
   public:
    static GenieEmbeddingConfig_Handle_t add(std::shared_ptr<Config> config);
    static std::shared_ptr<Config> get(GenieEmbeddingConfig_Handle_t handle);
    static void remove(GenieEmbeddingConfig_Handle_t handle);

    Config(const char* configStr);
    qualla::json getJson() const;

   private:
    static qnn::util::HandleManager<Config> s_manager;
    qualla::json m_config;
  };

  static GenieEmbedding_Handle_t add(std::shared_ptr<Embedding> embedding);
  static std::shared_ptr<Embedding> get(GenieEmbedding_Handle_t handle);
  static void remove(GenieEmbedding_Handle_t handle);

  Embedding(std::shared_ptr<Config> config);

  Embedding(const Embedding&)            = delete;
  Embedding& operator=(const Embedding&) = delete;
  Embedding(Embedding&&)                 = delete;
  Embedding& operator=(Embedding&&)      = delete;

  int32_t generate(const char* queryStr,
                   GenieEmbedding_GenerateCallback_t callback,
                   const void* userData);

 private:
  std::unique_ptr<qualla::Embedding> m_quallaEmbedding;
  static qnn::util::HandleManager<Embedding> s_manager;
  static std::atomic<std::uint32_t> s_nameCounter;
};
}  // namespace genie
