//==============================================================================
//
//  Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
//  All Rights Reserved.
//  Confidential and Proprietary - Qualcomm Technologies, Inc.
//
//==============================================================================

#include "QnnInterface.h"
#include "QnnTypes.h"
#include "System/QnnSystemInterface.h"

#include <iostream>
#include <map>
#include <queue>
#include <string>
#include <unordered_map>
#include <vector>

#include "QnnTypeDef.hpp"
#include "Log.hpp"

/**
 * @brief Frees all memory allocated tensor attributes.
 *
 * @param[in] tensorWrapper tensor object to free
 *
 * @return Error code
 */
bool freeQnnTensorWrapper(TensorWrapper& tensorWrapper);

/**
 * @brief Loops through and frees all memory allocated tensor attributes for each tensorWrapper
 * object.
 *
 * @param[in] tensorWrappers array of tensor objects to free
 *
 * @param[in] numTensors length of the above tensorWrappers array
 *
 * @return Error code
 */
bool freeQnnTensorWrappers(TensorWrapper*& tensorWrappers, uint32_t numTensors);

/**
 * @brief A helper function to free memory malloced for communicating the Graph for a model(s)
 *
 * @param[in] graphsInfo Pointer pointing to location of graph objects
 *
 * @param[in] numGraphs The number of graph objects the above pointer is pointing to
 *
 * @return Error code
 *
 */
bool freeGraphsInfo(GraphInfoPtr_t** graphsInfo, uint32_t numGraphs);

bool freeGraphInfo(GraphInfo_t* graphInfo);

bool copyMetadataToGraphsInfo(
        const QnnSystemContext_BinaryInfo_t* binaryInfo,
        GraphInfo_t**&                       graphsInfo,
        uint32_t&                            graphsCount
);

bool copyGraphsInfo(
        const QnnSystemContext_GraphInfo_t* graphsInput,
        const uint32_t                      numGraphs,
        GraphInfo_t**&                      graphsInfo
);

bool copyGraphsInfoV1(
        const QnnSystemContext_GraphInfoV1_t* graphInfoSrc,
        GraphInfo_t*                          graphInfoDst
);

bool copyTensorsInfo(
        const Qnn_Tensor_t* tensorsInfoSrc,
        TensorWrapper*&     tensorWrappers,
        uint32_t            tensorsCount
);

bool   fillDims(std::vector<size_t>& dims, uint32_t* inDimensions, uint32_t rank);
size_t getFileSize(std::string filePath);
bool   readBinaryFromFile(std::string filePath, void* buffer, size_t bufferSize);
bool   mmapBinaryFile(std::string filePath, void** buffer, size_t bufferSize);
bool updateMetaDataToGraphsInfo(const QnnSystemContext_BinaryInfo_t* binaryInfo,GraphInfo_t**  graphsInfo,uint32_t& graphsCount);
bool updateGraphInfo(const QnnSystemContext_GraphInfo_t* graphsInput,
                     const uint32_t                      currCount,
                     GraphInfo_t*                        graphsInfo);
bool updateGraphInfoV1(const QnnSystemContext_GraphInfoV1_t* graphInfoSrc,
                       GraphInfo_t*                          graphInfoDst);
bool updateTensorInfo(const Qnn_Tensor_t* tensorsInfoSrc,
                      TensorWrapper*     tensorWrappers,
                      uint32_t            tensorsCount);
uint32_t getNumGraphInBinary(const QnnSystemContext_BinaryInfo_t* binaryInfo);