//==============================================================================
//
//  Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
//  All Rights Reserved.
//  Confidential and Proprietary - Qualcomm Technologies, Inc.
//
//==============================================================================
#pragma once

#include "QnnGraph.h"
#include "QnnTypes.h"
#include <vector>

struct BackendExtensionsConfigs {
    std::string sharedLibraryPath;
    std::string configFilePath;
    BackendExtensionsConfigs() : sharedLibraryPath(""), configFilePath("") {}
    BackendExtensionsConfigs(std::string sharedLibraryPath, std::string configFilePath)
        : sharedLibraryPath(sharedLibraryPath), configFilePath(configFilePath) {}
};

struct ContextConfigs {
    bool           priorityPresent;
    Qnn_Priority_t priority;
    ContextConfigs() : priorityPresent(false), priority(QNN_PRIORITY_UNDEFINED) {}
    ContextConfigs(Qnn_Priority_t priority) : priorityPresent(true), priority(priority) {}
};

struct GraphConfigs {
    std::string graphName;
    bool           priorityPresent;
    Qnn_Priority_t priority;
    GraphConfigs()
        : graphName(),
          priorityPresent(false), priority(QNN_PRIORITY_UNDEFINED) {
    }
};

struct ConfigOptions {
    BackendExtensionsConfigs  backendExtensionsConfigs;
    ContextConfigs            contextConfigs;
    std::vector<GraphConfigs> graphConfigs;
    ConfigOptions() : backendExtensionsConfigs(), contextConfigs(), graphConfigs() {}
};
