# =============================================================================
#
#  Copyright (c) 2015-2024 Qualcomm Technologies, Inc.
#  All Rights Reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.
#
# =============================================================================
from qti.aisw.converters.common import ir_graph as c_ir_graph
from qti.aisw.converters.common.converter_ir.op_adapter import ElementwiseNeuronOp
from qti.aisw.converters.tensorflow.common import LayerDescriptor, LayerResolver, LayerBuilder
from qti.aisw.converters.tensorflow.graph_matcher import (
    ConverterSequenceNode,
    GraphSequence
)


class SigmoidLayerResolver(LayerResolver, object):

    class Descriptor(LayerDescriptor):
        pass

    def __init__(self):
        self.sequence = GraphSequence([ConverterSequenceNode('root', ['Sigmoid'])])
        self.sequence.set_outputs(['root'])

    def resolve_layer(self, graph_matcher, graph_helper):
        matches = graph_matcher.match_sequence(self.sequence)
        if len(matches) == 0:
            return []
        potential_descriptors = []
        for match in matches:
            sigmoid_op = match['root']
            consumed_nodes = match.consumed_nodes
            potential_descriptors.append(
                SigmoidLayerResolver.Descriptor('Sigmoid', str(sigmoid_op.name), consumed_nodes))
        return potential_descriptors


class SigmoidLayerBuilder(LayerBuilder):
    def build_layer(self, ir_graph, converter_context, descriptor, input_descriptors, output_descriptors):
        """
        :type ir_graph: converters.common.converter_ir.op_graph.IROpGraph
        :type input_descriptors: [converters.tensorflow.common.LayerDescriptor]
        :type output_descriptors: [converters.tensorflow.common.LayerDescriptor]
        :type converter_context: converters.tensorflow.converter.ConverterContext
        :type descriptor: SigmoidLayerResolver.Descriptor
        :rtype: int
        """
        input_name = self.get_input_name(converter_context, descriptor, input_descriptors)
        output_name = descriptor.output_names[0]
        return ir_graph.add(ElementwiseNeuronOp(descriptor.layer_name,
                            operation=c_ir_graph.QNN_OP_ELEMENT_WISE_NEURON_OPERATION_SIGMOID, alpha=1.0),
                            input_name,
                            output_name)
