#==============================================================================
#
#  Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
#  All rights reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.
#
#==============================================================================

from qti.aisw.core.model_level_api.workflow.workflow import Workflow, WorkflowMode


class ContextBinaryGenerator(Workflow):
    def __init__(self, backend, model, executor=None, sdk_path=None):
        super().__init__(backend, model, executor, sdk_path)
        workflow_mode = WorkflowMode.CONTEXT_BINARY_GENERATION
        self._backend.workflow_mode = workflow_mode

        if self._executor is None:
            target_default_executor_cls = self._backend.target.get_default_executor_cls()
            self._executor = target_default_executor_cls()

        self._executor.setup(workflow_mode,
                             self._backend,
                             self._model,
                             self._sdk_path,
                             None,
                             None)


    def generate(self, output_path='./output/', output_filename=None, config=None):
        context_bin, profiling_data =  self._executor.generate_context_binary(config,
                                                                              self._backend,
                                                                              self._model,
                                                                              self._sdk_path,
                                                                              output_path,
                                                                              output_filename)
        if profiling_data is not None:
            self._profiling_data.append(profiling_data)
        return context_bin