//==============================================================================
//
//  Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
//  All Rights Reserved.
//  Confidential and Proprietary - Qualcomm Technologies, Inc.
//
//==============================================================================

#pragma once

#include <mutex>
#include <vector>

#include "qualla/detail/json.hpp"

namespace genie {
namespace profiling {

/**
 * TraceData represents the actual data that gets stored in the logbook
 */
struct TraceData {
  const char* traceNamespace{nullptr};
  const char* functionName{nullptr};
  uint64_t startTime{0ul};
  uint64_t duration{0ul};
  size_t stackDepth{0u};
};

/**
 * TraceLogger will capture trace events for Traceable objects.
 */
class TraceLogger final {
 private:
  std::mutex m_mutex;
  std::vector<TraceData> m_log;
  const size_t m_id{0};

 public:
  /**
   * @param id  Specifies the tid to use for serialized events.
   */
  TraceLogger(const size_t id = 0);
  virtual ~TraceLogger() = default;

  TraceLogger(const TraceLogger&)            = delete;
  TraceLogger(TraceLogger&&)                 = delete;
  TraceLogger& operator=(const TraceLogger&) = delete;
  TraceLogger& operator=(TraceLogger&&)      = delete;

  /**
   * Inserts the provided event into this log.
   */
  void insert(const TraceData& event);

  /**
   * Appends serialized trace events to the provided json.
   */
  void serialize(qualla::json& json);
};

}  // namespace profiling
}  // namespace genie