# ==============================================================================
#
# Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.
#
# ==============================================================================

import inspect
import os
import sys


def _setup_qairt_vm_env():
    from qairt.cli.qairt_vm.qairt_vm_factory import get_platform_qairt_vm

    # If user already has a QAIRT_SDK_ROOT set, use that
    # Otherwise, use the default SDK root location at install location
    qairt_root_dir = os.environ.get("QAIRT_SDK_ROOT", None)
    qairt_vm = get_platform_qairt_vm(qairt_root_dir=qairt_root_dir)
    if len(qairt_vm.check_qairt_dev_env()):
        qairt_vm.fix()
    os.environ["QAIRT_SDK_ROOT"] = qairt_vm.qairt_root_dir
    os.environ["QNN_SDK_ROOT"] = qairt_vm.qairt_root_dir
    os.environ["LIBRARY_SEARCH_PATH"] = qairt_vm.qairt_os_lib_dir
    os.environ["PATH"] = qairt_vm.qairt_os_lib_dir + os.pathsep + os.environ["PATH"]
    sys.path.append(qairt_vm.qairt_py_lib_dir)


# To avoid import errors when running the qairt-vm CLI tool,
# we delay importing qairt until it's actually needed, as some of its imports
# rely on modules from the SDK, which may not be available when running the CLI tool.
# Additionally, until QAIRT DEV is official we want to avoid interference of qairt-vm
qairt_dev_env = os.environ.get("QAIRT_DEV_ENV", None) == "True"
qairt_vm_cli_exe = any(
    "qairt-vm" in frame.filename or "qairt_vm" in frame.filename for frame in inspect.stack()
)

should_import_qairt = False
if not qairt_dev_env:
    should_import_qairt = True
elif qairt_dev_env and not qairt_vm_cli_exe:
    should_import_qairt = True

if should_import_qairt:
    # QAIRT setup
    is_test_env = any("test" in frame.filename for frame in inspect.stack())
    if not is_test_env and qairt_dev_env:
        _setup_qairt_vm_env()

    from qairt.api._loader import load
    from qairt.api.compiled_model import CompiledModel
    from qairt.api.compiler._compile import compile
    from qairt.api.compiler.config import CompileConfig
    from qairt.api.configs import (
        BackendType,
        Device,
        DeviceInfo,
        DevicePlatformType,
        DspArchitecture,
        ExecutionResult,
        RemoteDeviceIdentifier,
    )
    from qairt.api.converter._convert import convert
    from qairt.api.converter.converter_config import CalibrationConfig, ConverterConfig
    from qairt.api.executor import ExecutionConfig
    from qairt.api.model import Model
    from qairt.api.profiler import Profiler
    from qairt.modules.cache_module import CacheInfo, CacheModule
    from qairt.modules.dlc_module import DlcModule
    from qairt.utils.asset_utils import AssetType
