# =============================================================================
#
# Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
# All rights reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.
#
# =============================================================================
import argparse
from abc import ABC, abstractmethod


class Parser(ABC):
    """Abstract class for all the parsers."""

    def __init__(self, component=None):
        self._parser = argparse.ArgumentParser(
            prog=f"qairt-accuracy-debugger {component}",
            formatter_class=argparse.RawDescriptionHelpFormatter,
            conflict_handler="resolve",
        )
        self.required = self._parser.add_argument_group("required arguments")
        self.optional = self._parser.add_argument_group("optional arguments")

    def parse(self, args: list) -> argparse.Namespace:
        """Parse the arguments.

        Args:
            args (list): Arguments from the user to be parsed
        Returns:
            argparse.Namespace: parsed arguments
        """
        self._initialize()
        parsed_args = self._parser.parse_args(args)

        return self._verify_and_update_parsed_args(parsed_args)

    @abstractmethod
    def _initialize(self):
        pass

    @abstractmethod
    def _verify_and_update_parsed_args(self, parsed_args: argparse.Namespace) -> argparse.Namespace:
        return parsed_args
