# ==============================================================================
#
# Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
# All Rights Reserved.
# Confidential and Proprietary - Qualcomm Technologies, Inc.
#
# ==============================================================================
"""Abstract base class definition for Pattern matching"""

from abc import ABCMeta, abstractmethod

import onnx_graphsurgeon as gs

from qti.aisw.tools.core.utilities.framework.frameworks.onnx.transform.graph_manager import GraphManager


class Pattern(metaclass=ABCMeta):
    """Abstract base class definition for Pattern matching"""

    def __init__(self, graph: GraphManager) -> None:
        self.graph = graph

    @abstractmethod
    def capture(self, node: gs.Node, **kwargs) -> bool:
        """Capture the details of pattern defined by a node

        Args:
            node: The starting node that defines a pattern

        Returns:
            True if 'node' captures the defined pattern, else False
        """
        pass

    @abstractmethod
    def replace(self, node: gs.Node, **kwargs) -> bool:
        """Process the pattern matching replacement

        Args:
            node: Pattern-matched node.
                  Note that this is not necessarily the same as the node that was passed to capture,
                  although it is the same node in most cases
                  It is differentiated here if there is any instance where a different node is to be replaced

        Returns:
            True if the replacement was successful, else False

        """
        pass
