# ==============================================================================
#
#  Copyright (c) Qualcomm Technologies, Inc. and/or its subsidiaries.
#  All rights reserved.
#  Confidential and Proprietary - Qualcomm Technologies, Inc.
#
# ==============================================================================
"""
This module provides the base ir visitor class
"""
from onnxscript import ir


class BaseTreeVisitor():

    """
    Base class for the ir graph rewriter,
    used for ir inspectation or analysis,
    this class shouldn't be used to change any IR topology
    """

    def __init__(self, graph: ir.Graph):
        self.graph = graph

    def apply(self):
        """
        Apply the analysis/inspectation
        """
        for n in self.graph:
            self.visit_node(n)

    def visit_node(self, node: ir.Node):
        """
        Entry for visit each node
        if visit_node_{op_type} method is defined, then call this method
        otherwise call the default method visit_general_node

        Args:
            node: ir node to be visited
        """
        if hasattr(self, f"visit_node_{node.op_type}"):
            getattr(self, f"visit_node_{node.op_type}")(node)
        else:
            self.visit_general_node(node)

    def visit_general_node(self, node: ir.Node):
        """
        The default method to visit the node

        Args:
            node: ir node to be visited
        """
